
<?php ($active = 'dashboard'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($assets = $tenant ? \App\Models\Asset::where('tenant_id', $tenant->id)->get() : collect()); ?>
<?php ($assetCount = $assets->count()); ?>
<?php ($activeCount = $assets->filter(fn ($asset) => ($asset->lifecycle_status ?? 'active') !== 'down')->count()); ?>
<?php ($availability = $assetCount ? round(($activeCount / $assetCount) * 100, 1) : 0); ?>
<?php ($openWorkOrders = $tenant ? \App\Models\WorkOrder::where('tenant_id', $tenant->id)->where('status', 'open')->count() : 0); ?>
<?php ($telemetryCount = $tenant ? \App\Models\Telemetry::where('tenant_id', $tenant->id)->count() : 0); ?>
<?php ($telemetryHealth = $assetCount ? round(min(100, ($telemetryCount / max(1, $assetCount)) * 100)) : 0); ?>
<?php ($avgFuelRate = $tenant ? \App\Models\FuelLog::where('tenant_id', $tenant->id)->avg('quantity') : null); ?>
<?php ($queueWorkOrders = $tenant ? \App\Models\WorkOrder::with('asset')->where('tenant_id', $tenant->id)->latest()->take(3)->get() : collect()); ?>
<?php ($aiInsights = $tenant ? \App\Models\AiInsight::where('tenant_id', $tenant->id)->latest()->take(2)->get() : collect()); ?>
<?php ($alerts = $tenant ? \App\Models\Alarm::with('asset')->where('tenant_id', $tenant->id)->latest()->take(2)->get() : collect()); ?>

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Command Center</p>
        <h1>Fleet Command</h1>
        <p class="sub">Live pulse of assets, telemetry, and maintenance readiness.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/exports/dashboard-snapshot.pdf">Export Snapshot</a>
        <button class="btn btn-primary">Launch Trip</button>
    </div>
</section>

<section class="kpi-grid">
    <article class="card kpi accent">
        <div class="kpi-label"><a href="/ui/kpis/Availability">Fleet Availability</a></div>
        <div class="kpi-value"><?php echo e($availability); ?>%</div>
        <div class="kpi-meta">+2.1% vs last week</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/assets/A-041">Active Assets</a></div>
        <div class="kpi-value"><?php echo e($activeCount); ?></div>
        <div class="kpi-meta"><?php echo e($openWorkOrders); ?> scheduled for service</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/telemetry/TM-881">Telemetry Health</a></div>
        <div class="kpi-value"><?php echo e($telemetryHealth); ?>%</div>
        <div class="kpi-meta"><?php echo e(max(0, $assetCount - $telemetryCount)); ?> sensors degraded</div>
    </article>
    <article class="card kpi dark">
        <div class="kpi-label"><a href="/ui/fuel/FL-1204">Fuel Efficiency</a></div>
        <div class="kpi-value"><?php echo e($avgFuelRate ? number_format($avgFuelRate, 1) : '-'); ?> L/hr</div>
        <div class="kpi-meta">AI optimization active</div>
    </article>
</section>

<section class="grid-2">
    <article class="card chart-card">
        <div class="card-head">
            <div>
                <div class="card-title">Operational Load</div>
                <div class="card-sub">Trips and utilization over 7 days</div>
            </div>
            <div class="chip">Realtime</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 62%"><span>Mon</span></div>
                <div class="chart-bar" style="--value: 78%"><span>Tue</span></div>
                <div class="chart-bar" style="--value: 54%"><span>Wed</span></div>
                <div class="chart-bar" style="--value: 84%"><span>Thu</span></div>
                <div class="chart-bar" style="--value: 71%"><span>Fri</span></div>
                <div class="chart-bar" style="--value: 66%"><span>Sat</span></div>
                <div class="chart-bar" style="--value: 52%"><span>Sun</span></div>
            </div>
            <div class="chart-overlay">
                <div class="chart-stat">
                    <span>Trips</span>
                    <strong>428</strong>
                </div>
                <div class="chart-stat">
                    <span>Utilization</span>
                    <strong>84%</strong>
                </div>
                <div class="chart-stat">
                    <span>Idle Hours</span>
                    <strong>12.4h</strong>
                </div>
            </div>
        </div>
        <div class="legend">
            <span class="legend-item">Trips</span>
            <span class="legend-item">Asset Hours</span>
            <span class="legend-item">Idle</span>
        </div>
    </article>

    <article class="card map-card">
        <div class="card-head">
            <div>
                <div class="card-title">Live Fleet Map</div>
                <div class="card-sub">43 vehicles in motion</div>
            </div>
            <button class="btn btn-ghost">Open full map</button>
        </div>
        <div class="map-placeholder">
            <img class="map-overlay" src="/ui-assets/images/map-grid.svg" alt="" aria-hidden="true">
            <div class="pulse"></div>
            <div class="pulse small"></div>
            <div class="pulse medium"></div>
            <div class="map-label">Western Quarry Zone</div>
        </div>
    </article>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Maintenance Queue</div>
        <div class="list">
            <?php $__empty_1 = true; $__currentLoopData = $queueWorkOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="list-item">
                    <div>
                        <div class="item-title"><a href="/ui/work-orders/<?php echo e($order->id); ?>"><?php echo e($order->asset?->name ?? 'Work Order'); ?></a></div>
                        <div class="item-sub"><?php echo e($order->description ?? 'Scheduled work'); ?></div>
                    </div>
                    <span class="badge <?php echo e($order->status === 'open' ? 'badge-warning' : 'badge-live'); ?>"><?php echo e(ucfirst($order->status)); ?></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="list-item">
                    <div>
                        <div class="item-title">No open work orders</div>
                        <div class="item-sub">Maintenance queue is clear.</div>
                    </div>
                    <span class="badge">-</span>
                </div>
            <?php endif; ?>
        </div>
    </article>

    <article class="card">
        <div class="card-title">AI Recommendations</div>
        <?php $__empty_1 = true; $__currentLoopData = $aiInsights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="insight">
                <div class="insight-score"><?php echo e($insight->confidence ? number_format($insight->confidence, 0) : 75); ?></div>
                <div>
                    <div class="item-title"><a href="/ui/ai/<?php echo e($insight->id); ?>"><?php echo e(ucfirst(str_replace('_', ' ', $insight->type))); ?></a></div>
                    <div class="item-sub"><?php echo e($insight->payload['summary'] ?? 'AI insight available'); ?></div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="insight">
                <div class="insight-score">-</div>
                <div>
                    <div class="item-title">No AI insights yet</div>
                    <div class="item-sub">Upload data to generate recommendations.</div>
                </div>
            </div>
        <?php endif; ?>
    </article>

    <article class="card">
        <div class="card-title">Alert Stack</div>
        <div class="stack">
            <?php $__empty_1 = true; $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="stack-item">
                    <div>
                        <div class="item-title"><a href="/ui/alerts/<?php echo e($alert->id); ?>"><?php echo e($alert->message ?? 'Alert'); ?></a></div>
                        <div class="item-sub"><?php echo e($alert->asset?->name ?? 'Alert triggered'); ?></div>
                    </div>
                    <span class="badge badge-warning"><?php echo e(ucfirst($alert->severity ?? 'high')); ?></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="stack-item">
                    <div>
                        <div class="item-title">No active alerts</div>
                        <div class="item-sub">Systems operating normally.</div>
                    </div>
                    <span class="badge">-</span>
                </div>
            <?php endif; ?>
        </div>
    </article>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/dashboard.blade.php ENDPATH**/ ?>