
<?php ($active = 'tenants'); ?>
<?php ($tenantRecord = \App\Models\Tenant::withCount(['assets', 'users', 'sites', 'vehicles', 'workOrders', 'maintenanceRecords', 'devices', 'alarms', 'trips'])->where('id', $tenantId)->orWhere('name', $tenantId)->first()); ?>
<?php ($tenantUsers = $tenantRecord ? $tenantRecord->users()->with('roles')->orderBy('name')->get() : collect()); ?>
<?php ($openWorkOrders = $tenantRecord ? \App\Models\WorkOrder::where('tenant_id', $tenantRecord->id)->where('status', 'open')->count() : 0); ?>
<?php ($pmSchedules = $tenantRecord ? \App\Models\PmSchedule::where('tenant_id', $tenantRecord->id)->count() : 0); ?>

<?php $__env->startSection('title', 'Tenant Details'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Tenant</p>
        <h1><?php echo e($tenantRecord?->name ?? ($tenantId ?? 'Tenant')); ?></h1>
        <p class="sub">Company profile, branding, and integrations.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/tenants">Back to Tenants</a>
        <button class="btn btn-primary">Edit Tenant</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Profile</div>
        <div class="list">
            <div class="list-item"><span>Plan</span><span class="chip"><?php echo e($tenantRecord?->subscription_plan ?? 'Enterprise'); ?></span></div>
            <div class="list-item"><span>Status</span><span class="badge <?php echo e(($tenantRecord?->status ?? 'active') === 'active' ? 'badge-live' : 'badge'); ?>"><?php echo e(ucfirst($tenantRecord?->status ?? 'active')); ?></span></div>
            <div class="list-item"><span>Users</span><span class="chip"><?php echo e($tenantRecord?->users_count ?? 0); ?></span></div>
            <div class="list-item"><span>Sites</span><span class="chip"><?php echo e($tenantRecord?->sites_count ?? 0); ?></span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Integrations</div>
        <div class="list">
            <div class="list-item"><span>WhatsApp</span><span class="badge badge-live">Enabled</span></div>
            <div class="list-item"><span>SMS</span><span class="badge">Enabled</span></div>
            <div class="list-item"><span>Telegram</span><span class="badge badge-warning">Paused</span></div>
        </div>
    </div>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Assets</div>
        <div class="metric"><?php echo e($tenantRecord?->assets_count ?? 0); ?></div>
        <div class="metric-sub">Fleet assets onboarded</div>
    </article>
    <article class="card">
        <div class="card-title">Fleet</div>
        <div class="metric"><?php echo e($tenantRecord?->vehicles_count ?? 0); ?></div>
        <div class="metric-sub">Vehicles tracked</div>
    </article>
    <article class="card">
        <div class="card-title">Work Orders</div>
        <div class="metric"><?php echo e($tenantRecord?->work_orders_count ?? 0); ?></div>
        <div class="metric-sub">Open: <?php echo e($openWorkOrders); ?></div>
    </article>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">PM Schedules</div>
        <div class="metric"><?php echo e($pmSchedules); ?></div>
        <div class="metric-sub">Active preventive plans</div>
    </article>
    <article class="card">
        <div class="card-title">Maintenance Logs</div>
        <div class="metric"><?php echo e($tenantRecord?->maintenance_records_count ?? 0); ?></div>
        <div class="metric-sub">Total maintenance records</div>
    </article>
    <article class="card">
        <div class="card-title">Telemetry Devices</div>
        <div class="metric"><?php echo e($tenantRecord?->devices_count ?? 0); ?></div>
        <div class="metric-sub">Connected sensors</div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Tenant Users</div>
            <div class="card-sub">Roles and access for <?php echo e($tenantRecord?->name ?? 'this tenant'); ?></div>
        </div>
        <div class="chip">Total <?php echo e($tenantRecord?->users_count ?? 0); ?></div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Name</div><div>Email</div><div>Role</div><div>Site</div><div>Status</div><div>Action</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $tenantUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="table-row">
                <div><?php echo e($user->name); ?></div>
                <div><?php echo e($user->email); ?></div>
                <div><?php echo e($user->roles->pluck('name')->implode(', ') ?: '-'); ?></div>
                <div><?php echo e($user->site?->name ?? 'All Sites'); ?></div>
                <div><span class="badge badge-live">Active</span></div>
                <div><a href="/ui/users/<?php echo e($user->id); ?>">View</a></div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No users found.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/tenant-detail.blade.php ENDPATH**/ ?>