
<?php ($active = 'kpis'); ?>

<?php $__env->startSection('title', 'KPI Studio'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">KPI Studio</p>
        <h1>Performance Metrics</h1>
        <p class="sub">Design, track, and benchmark operational KPIs.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Share</button>
        <button class="btn btn-primary">New KPI</button>
    </div>
</section>

<section class="grid-3">
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/Utilization">Utilization Rate</a></div>
        <div class="kpi-value">82%</div>
        <div class="kpi-meta">Target 85%</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/Cost%20per%20Ton">Cost per Ton</a></div>
        <div class="kpi-value">$14.10</div>
        <div class="kpi-meta">-3% month over month</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/Safety%20Incidents">Safety Incidents</a></div>
        <div class="kpi-value">0</div>
        <div class="kpi-meta">120 days streak</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/Availability">Availability</a></div>
        <div class="kpi-value">95.4%</div>
        <div class="kpi-meta">Target 96%</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/MTBF">MTBF</a></div>
        <div class="kpi-value">212 hrs</div>
        <div class="kpi-meta">+6% vs last quarter</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/MTTR">MTTR</a></div>
        <div class="kpi-value">3.8 hrs</div>
        <div class="kpi-meta">-9% vs last quarter</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/Fuel%20Efficiency">Fuel Efficiency</a></div>
        <div class="kpi-value">14.7 L/hr</div>
        <div class="kpi-meta">AI optimization active</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/Downtime">Downtime</a></div>
        <div class="kpi-value">6.2 hrs</div>
        <div class="kpi-meta">-1.4 hrs week over week</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/kpis/Maintenance%20Compliance">Maintenance Compliance</a></div>
        <div class="kpi-value">91%</div>
        <div class="kpi-meta">Target 95%</div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">KPI Trends</div>
                <div class="card-sub">Utilization, availability, and cost per ton</div>
            </div>
            <div class="chip">Last 12 weeks</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 58%"><span>W1</span></div>
                <div class="chart-bar" style="--value: 62%"><span>W2</span></div>
                <div class="chart-bar" style="--value: 70%"><span>W3</span></div>
                <div class="chart-bar" style="--value: 64%"><span>W4</span></div>
                <div class="chart-bar" style="--value: 76%"><span>W5</span></div>
                <div class="chart-bar" style="--value: 72%"><span>W6</span></div>
                <div class="chart-bar" style="--value: 80%"><span>W7</span></div>
                <div class="chart-bar" style="--value: 74%"><span>W8</span></div>
                <div class="chart-bar" style="--value: 82%"><span>W9</span></div>
                <div class="chart-bar" style="--value: 78%"><span>W10</span></div>
                <div class="chart-bar" style="--value: 85%"><span>W11</span></div>
                <div class="chart-bar" style="--value: 88%"><span>W12</span></div>
            </div>
            <div class="chart-overlay">
                <div class="chart-stat">
                    <span>Utilization</span>
                    <strong>82%</strong>
                </div>
                <div class="chart-stat">
                    <span>Availability</span>
                    <strong>95%</strong>
                </div>
                <div class="chart-stat">
                    <span>Cost / ton</span>
                    <strong>$14.10</strong>
                </div>
            </div>
        </div>
        <div class="legend">
            <span class="legend-item">Utilization</span>
            <span class="legend-item">Availability</span>
            <span class="legend-item">Cost / ton</span>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Variance Drivers</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Fuel variance</div>
                    <div class="item-sub">Idle hours up 8%</div>
                </div>
                <span class="badge badge-warning">Watch</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Maintenance backlog</div>
                    <div class="item-sub">4 PMs overdue at Quarry</div>
                </div>
                <span class="badge">Monitor</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Payload compliance</div>
                    <div class="item-sub">96% within target</div>
                </div>
                <span class="badge badge-live">Stable</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Parts spend</div>
                    <div class="item-sub">Hydraulic components +12%</div>
                </div>
                <span class="badge badge-warning">Rising</span>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Targets at Risk</div>
            <div class="card-sub">Assets impacting KPI performance</div>
        </div>
        <a class="btn btn-ghost" href="/exports/kpis.pdf">Export</a>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Asset</div><div>KPI</div><div>Current</div><div>Target</div><div>Variance</div><div>Status</div>
        </div>
        <div class="table-row">
            <div>Hauler H-44</div><div>Fuel Efficiency</div><div>16.9 L/hr</div><div>14.2 L/hr</div><div>+19%</div><div><span class="badge badge-warning">At Risk</span></div>
        </div>
        <div class="table-row">
            <div>Crusher CR-01</div><div>Availability</div><div>91.2%</div><div>95%</div><div>-3.8%</div><div><span class="badge badge-warning">At Risk</span></div>
        </div>
        <div class="table-row">
            <div>Mixer MT-09</div><div>Utilization</div><div>74%</div><div>82%</div><div>-8%</div><div><span class="badge">Monitor</span></div>
        </div>
        <div class="table-row">
            <div>Conveyor CV-03</div><div>Downtime</div><div>7.6h</div><div>4.0h</div><div>+3.6h</div><div><span class="badge badge-danger">Critical</span></div>
        </div>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Maintenance Compliance</div>
        <div class="metric">91%</div>
        <div class="metric-sub">82 of 90 PMs completed on time</div>
        <div class="cost-row"><span>On time</span><span class="chip">82</span></div>
        <div class="cost-row"><span>Overdue</span><span class="chip">8</span></div>
        <div class="cost-row"><span>Average delay</span><span class="chip">3.2 days</span></div>
    </article>
    <article class="card">
        <div class="card-title">AI KPI Notes</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Shift B utilization lift</div>
                    <div class="item-sub">Reassign 2 haulers to night shift</div>
                </div>
                <span class="badge badge-ai">AI</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Crusher bottleneck</div>
                    <div class="item-sub">Screen SC-01 driving throughput loss</div>
                </div>
                <span class="badge badge-warning">Action</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Fuel compliance</div>
                    <div class="item-sub">Idle control policy saved 6.4%</div>
                </div>
                <span class="badge badge-live">Positive</span>
            </div>
        </div>
    </article>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/kpis.blade.php ENDPATH**/ ?>