<?php
    $active = 'agent-notifications';
?>

<?php $__env->startSection('title', 'AI Agent Notifications'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Intelligence</p>
        <h1>AI Agent Notifications</h1>
        <p class="sub">Automated compliance, prediction, KPI, and cost control alerts.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Export Log</button>
        <button class="btn btn-primary">Run Agents</button>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Agent Runs</div>
            <div class="card-sub">Latest notifications delivered to Telegram</div>
        </div>
        <div class="chip">Last 50</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Agent</div><div>Title</div><div>Severity</div><div>Status</div><div>Sent</div><div>Recipients</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $severity = strtolower($notification->severity ?? 'info');
                $badgeClass = $severity === 'alarm' ? 'badge-warning' : ($severity === 'warn' ? 'badge-live' : 'badge');
                $recipients = $notification->recipients ? implode(', ', $notification->recipients) : '-';
            ?>
            <a class="table-row" href="/ui/agent-notifications/<?php echo e($notification->id); ?>">
                <div><?php echo e($notification->agent_name); ?></div>
                <div><?php echo e($notification->title); ?></div>
                <div><span class="badge <?php echo e($badgeClass); ?>"><?php echo e(strtoupper($severity)); ?></span></div>
                <div><?php echo e(ucfirst($notification->status)); ?></div>
                <div><?php echo e($notification->sent_at?->format('M d H:i') ?? '-'); ?></div>
                <div><?php echo e($recipients); ?></div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No agent notifications yet.</div>
                <div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/agent-notifications.blade.php ENDPATH**/ ?>