<?php ($active = 'assets'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($assets = $tenant ? \App\Models\Asset::with('site')->where('tenant_id', $tenant->id)->orderBy('name')->get() : collect()); ?>
<?php ($assets = $assets->unique(fn ($asset) => $asset->asset_tag ?: $asset->id)->values()); ?>
<?php ($categoryFilter = request('category')); ?>
<?php ($categories = $assets->map(fn ($asset) => $asset->category ?: 'Uncategorized')->unique()->sort()->values()); ?>
<?php ($filteredAssets = $categoryFilter && strtolower($categoryFilter) !== 'all' ? $assets->filter(fn ($asset) => ($asset->category ?: 'Uncategorized') === $categoryFilter)->values() : $assets); ?>
<?php ($assetCount = $filteredAssets->count()); ?>
<?php ($lifecycleCounts = $filteredAssets->groupBy(fn ($asset) => strtolower($asset->lifecycle_status ?: 'active'))->map->count()); ?>
<?php ($assetsByCategory = $filteredAssets->groupBy(fn ($asset) => $asset->category ?: 'Uncategorized')); ?>

<?php $__env->startSection('title', 'Assets'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Assets</p>
        <h1>Asset Portfolio</h1>
        <p class="sub">Track lifecycle, warranties, and utilization by site.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Import</button>
        <button class="btn btn-primary">Add Asset</button>
    </div>
</section>

<section class="card filters">
    <form class="filter-row" method="get">
        <input class="input" name="q" value="<?php echo e(request('q')); ?>" placeholder="Search assets" />
        <select class="select" name="site">
            <option value="">All Sites</option>
            <option>North Ridge</option>
            <option>East Yard</option>
        </select>
        <select class="select" name="status">
            <option value="">Status: Any</option>
            <option>Active</option>
            <option>Inactive</option>
        </select>
        <select class="select" name="category">
            <option value="all" <?php if(!$categoryFilter || strtolower($categoryFilter) === 'all'): echo 'selected'; endif; ?>>All Categories</option>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category); ?>" <?php if($categoryFilter === $category): echo 'selected'; endif; ?>><?php echo e($category); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button class="btn btn-ghost" type="submit">Apply</button>
        <a class="btn btn-ghost" href="/ui/assets">Reset</a>
    </form>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Asset Health Trend</div>
                <div class="card-sub">Average health score</div>
            </div>
            <div class="chip">Last 12 weeks</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 86 L40 78 L80 74 L120 68 L160 62 L200 58 L240 52 L260 46 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,86 40,78 80,74 120,68 160,62 200,58 240,52 260,46"></polyline>
                <circle class="trend-dot" cx="80" cy="74" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="62" r="3"></circle>
                <circle class="trend-dot" cx="240" cy="52" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Avg health 88-94%</span>
            <span>High risk assets 6</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Lifecycle Mix</div>
            <div class="card-sub">Active, standby, down</div>
        </div>
        <div class="chip"><?php echo e($assetCount); ?> assets</div>
    </div>
    <div class="chart-placeholder chart-placeholder--bars">
        <div class="chart-bars">
            <div class="chart-bar" style="--value: <?php echo e($assetCount ? round(($lifecycleCounts['active'] ?? 0) / $assetCount * 100) : 0); ?>%"><span>Active</span></div>
            <div class="chart-bar" style="--value: <?php echo e($assetCount ? round(($lifecycleCounts['standby'] ?? 0) / $assetCount * 100) : 0); ?>%"><span>Standby</span></div>
            <div class="chart-bar" style="--value: <?php echo e($assetCount ? round(($lifecycleCounts['down'] ?? 0) / $assetCount * 100) : 0); ?>%"><span>Down</span></div>
            <div class="chart-bar" style="--value: <?php echo e($assetCount ? round(($lifecycleCounts['retired'] ?? 0) / $assetCount * 100) : 0); ?>%"><span>Retired</span></div>
        </div>
    </div>
</article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Assets</div>
            <div class="card-sub"><?php echo e($assetCount); ?> tracked assets</div>
        </div>
        <div class="chip">Updated <?php echo e(now()->diffForHumans()); ?></div>
    </div>

    <div class="table">
        <div class="table-row table-head">
            <div>Asset</div><div>Name</div><div>Category</div><div>Location</div><div>Status</div><div>Health</div><div>Value</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $assetsByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="table-row">
                <div><strong><?php echo e($category); ?></strong></div>
                <div><?php echo e($group->count()); ?> assets</div>
                <div></div><div></div><div></div><div></div><div></div>
            </div>
            <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php ($health = $asset->lifecycle_status === 'down' ? 68 : 80 + ($asset->id % 20)); ?>
                <?php ($value = $asset->current_value ?? $asset->yearly_budget); ?>
                <a class="table-row" href="/ui/assets/<?php echo e($asset->id); ?>">
                    <div class="media-cell">
                        <img class="thumb" src="/ui-assets/images/asset-excavator.svg" alt="<?php echo e($asset->name); ?>">
                        <div><?php echo e($asset->asset_tag ?: 'ASSET'); ?></div>
                    </div>
                    <div><?php echo e($asset->name); ?></div>
                    <div><?php echo e($asset->category ?: 'Uncategorized'); ?></div>
                    <div><?php echo e($asset->site?->name ?? $asset->location ?? 'Unassigned'); ?></div>
                    <div>
                        <span class="badge <?php echo e($asset->lifecycle_status === 'down' ? 'badge-warning' : 'badge-live'); ?>">
                            <?php echo e(ucfirst($asset->lifecycle_status ?: 'active')); ?>

                        </span>
                    </div>
                    <div><?php echo e($health); ?>%</div>
                    <div><?php echo e($value !== null ? '$' . number_format($value, 0) : '-'); ?></div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No assets found.</div><div></div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/assets.blade.php ENDPATH**/ ?>