
<?php ($active = 'purchase-requests'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($requests = $tenant ? \App\Models\PurchaseRequest::with('site')->where('tenant_id', $tenant->id)->orderByDesc('created_at')->get() : collect()); ?>
<?php ($statusOptions = $requests->pluck('status')->filter()->unique()->values()); ?>
<?php ($siteOptions = $requests->map(fn ($request) => $request->site?->name)->filter()->unique()->values()); ?>
<?php ($pendingCount = $requests->whereIn('status', ['pending', 'awaiting', 'submitted'])->count()); ?>
<?php ($approvedThisWeek = $requests->where('status', 'approved')->filter(fn ($request) => $request->created_at && $request->created_at->greaterThanOrEqualTo(now()->subDays(7)))->count()); ?>
<?php ($avgCycle = $requests->where('status', 'approved')->map(fn ($request) => $request->updated_at && $request->created_at ? $request->updated_at->diffInDays($request->created_at) : null)->filter()->avg()); ?>

<?php $__env->startSection('title', 'Purchase Requests'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Supply Chain</p>
        <h1>Purchase Requests</h1>
        <p class="sub">Capture demand, route approvals, and track spend intent.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Approval Queue</button>
        <button class="btn btn-primary">New Request</button>
    </div>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Pending Approval</div>
        <div class="metric"><?php echo e($pendingCount); ?></div>
        <div class="metric-sub">Awaiting manager sign-off</div>
    </article>
    <article class="card">
        <div class="card-title">Approved This Week</div>
        <div class="metric"><?php echo e($approvedThisWeek); ?></div>
        <div class="metric-sub">$<?php echo e(number_format($requests->where('status', 'approved')->sum('total_estimated_cost'), 0)); ?> total value</div>
    </article>
    <article class="card">
        <div class="card-title">Avg Cycle Time</div>
        <div class="metric"><?php echo e($avgCycle ? number_format($avgCycle, 1) : '0.0'); ?> days</div>
        <div class="metric-sub">Request to approval</div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Request Volume</div>
                <div class="card-sub">Last 8 weeks</div>
            </div>
            <div class="chip">Trend</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 42%"><span>W1</span></div>
                <div class="chart-bar" style="--value: 48%"><span>W2</span></div>
                <div class="chart-bar" style="--value: 56%"><span>W3</span></div>
                <div class="chart-bar" style="--value: 52%"><span>W4</span></div>
                <div class="chart-bar" style="--value: 62%"><span>W5</span></div>
                <div class="chart-bar" style="--value: 58%"><span>W6</span></div>
                <div class="chart-bar" style="--value: 70%"><span>W7</span></div>
                <div class="chart-bar" style="--value: 64%"><span>W8</span></div>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Top Categories</div>
                <div class="card-sub">By value</div>
            </div>
            <div class="chip">Month to date</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 78%"><span>Parts</span></div>
                <div class="chart-bar" style="--value: 62%"><span>Tyres</span></div>
                <div class="chart-bar" style="--value: 48%"><span>Fuel</span></div>
                <div class="chart-bar" style="--value: 36%"><span>Contractors</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search requests" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Status: All</option>
            <?php $__currentLoopData = $statusOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e(strtolower($status)); ?>"><?php echo e(ucfirst($status)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <select class="select" data-filter-site>
            <option value="all">Site: All</option>
            <?php $__currentLoopData = $siteOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e(strtolower($site)); ?>"><?php echo e($site); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button class="btn btn-ghost" type="button" data-export-button data-export-type="purchase-requests">Export Selected</button>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Open Requests</div>
            <div class="card-sub">Awaiting approval or conversion</div>
        </div>
        <div class="chip">Updated 15m ago</div>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7">
            <div></div><div>ID</div><div>Site</div><div>Category</div><div>Amount</div><div>Priority</div><div>Status</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php ($status = strtolower($request->status ?? 'pending')); ?>
            <?php ($badge = $status === 'approved' ? 'badge-live' : ($status === 'pending' || $status === 'awaiting' ? 'badge-warning' : 'badge')); ?>
            <div class="table-row table-row-7" data-row data-row-id="<?php echo e($request->id); ?>" data-status="<?php echo e($status); ?>" data-site="<?php echo e(strtolower($request->site?->name ?? 'unassigned')); ?>" data-search="<?php echo e(strtolower($request->request_code . ' ' . ($request->site?->name ?? '') . ' ' . ($request->title ?? '') . ' ' . ($request->priority ?? '') . ' ' . $status)); ?>">
                <div class="table-select">
                    <input type="checkbox" data-row-select value="<?php echo e($request->id); ?>" />
                </div>
                <div><a href="/ui/purchase-requests/<?php echo e($request->id); ?>"><?php echo e($request->request_code); ?></a></div>
                <div><?php echo e($request->site?->name ?? 'Unassigned'); ?></div>
                <div><?php echo e($request->title ?? 'Procurement'); ?></div>
                <div><?php echo e($request->total_estimated_cost !== null ? '$' . number_format($request->total_estimated_cost, 0) : '-'); ?></div>
                <div><?php echo e(ucfirst($request->priority ?? 'medium')); ?></div>
                <div><span class="badge <?php echo e($badge); ?>"><?php echo e(ucfirst($status)); ?></span></div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row table-row-7">
                <div></div><div>No purchase requests found.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Approval Queue</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">PR-410 - Hydraulic kit</div>
                    <div class="item-sub">Awaiting Maintenance Manager</div>
                </div>
                <span class="badge badge-warning">Escalate</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">PR-412 - Concrete admixtures</div>
                    <div class="item-sub">Finance review</div>
                </div>
                <span class="badge">In review</span>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Auto-Generated Suggestions</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Reorder filters</div>
                    <div class="item-sub">Min stock breached at Workshop</div>
                </div>
                <span class="badge badge-ai">AI</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Order tyres for Hauler H-44</div>
                    <div class="item-sub">Tread depth below threshold</div>
                </div>
                <span class="badge badge-warning">Action</span>
            </div>
        </div>
    </article>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/purchase-requests.blade.php ENDPATH**/ ?>