
<?php ($active = 'work-orders'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($workOrder = $tenant ? \App\Models\WorkOrder::with(['asset', 'costs', 'parts.part'])->where('tenant_id', $tenant->id)->where(function ($query) use ($workOrderId) { $query->where('id', $workOrderId)->orWhere('reference_code', $workOrderId); })->first() : null); ?>
<?php ($costs = $workOrder?->costs ?? collect()); ?>
<?php ($costTotals = $costs->groupBy('type')->map(fn ($items) => $items->sum('total_cost'))); ?>

<?php $__env->startSection('title', 'Work Order Details'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Work Order</p>
        <h1><?php echo e($workOrder?->reference_code ?? ('WO-' . ($workOrder?->id ?? $workOrderId ?? ''))); ?></h1>
        <p class="sub">Corrective maintenance with parts and labor costs.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/work-orders">Back to Work Orders</a>
        <button class="btn btn-primary">Update Status</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Job Details</div>
        <div class="list">
            <div class="list-item"><span>Asset</span><span class="chip"><?php echo e($workOrder?->asset?->name ?? 'Asset'); ?></span></div>
            <div class="list-item"><span>Type</span><span class="chip"><?php echo e(ucfirst($workOrder?->type ?? 'service')); ?></span></div>
            <div class="list-item"><span>Priority</span><span class="badge badge-warning"><?php echo e(ucfirst($workOrder?->priority ?? 'medium')); ?></span></div>
            <div class="list-item"><span>Status</span><span class="badge badge-live"><?php echo e(ucfirst($workOrder?->status ?? 'open')); ?></span></div>
        </div>
        <p class="sub"><?php echo e($workOrder?->description ?? 'No description available.'); ?></p>
    </div>
    <div class="card">
        <div class="card-title">Costs</div>
        <div class="list">
            <div class="list-item"><span>Labor</span><span class="chip"><?php echo e(isset($costTotals['labor']) ? '$' . number_format($costTotals['labor'], 0) : '-'); ?></span></div>
            <div class="list-item"><span>Parts</span><span class="chip"><?php echo e(isset($costTotals['parts']) ? '$' . number_format($costTotals['parts'], 0) : '-'); ?></span></div>
            <div class="list-item"><span>Contractor</span><span class="chip"><?php echo e(isset($costTotals['contractor']) ? '$' . number_format($costTotals['contractor'], 0) : '-'); ?></span></div>
            <div class="list-item"><span>Total</span><span class="chip"><?php echo e($workOrder?->total_cost ? '$' . number_format($workOrder->total_cost, 0) : '-'); ?></span></div>
        </div>
    </div>
</section>

<section class="card">
    <div class="card-title">Parts Used</div>
    <div class="table">
        <div class="table-row table-head">
            <div>Part</div><div>Qty</div><div>Unit</div><div>Cost</div><div>Total</div><div>Status</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $workOrder?->parts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="table-row">
                <div><?php echo e($part->part?->name ?? 'Part'); ?></div>
                <div><?php echo e($part->quantity ?? 1); ?></div>
                <div><?php echo e($part->part?->unit ?? 'pcs'); ?></div>
                <div><?php echo e($part->unit_cost ? '$' . number_format($part->unit_cost, 0) : '-'); ?></div>
                <div><?php echo e($part->total_cost ? '$' . number_format($part->total_cost, 0) : '-'); ?></div>
                <div><span class="badge badge-live">Issued</span></div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No parts logged.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/work-order-detail.blade.php ENDPATH**/ ?>