<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo e($title); ?></title>
    <style>
        body { font-family: Arial, sans-serif; color: #111827; }
        .header { display: flex; align-items: center; gap: 16px; margin-bottom: 16px; }
        .logo { height: 48px; }
        h1 { font-size: 20px; margin: 0; }
        .subtitle { font-size: 12px; color: #4b5563; margin-top: 4px; }
        .meta { margin-top: 8px; font-size: 12px; color: #374151; }
        .meta-row { display: flex; gap: 8px; margin-top: 4px; }
        .meta-label { min-width: 120px; color: #6b7280; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; margin-top: 16px; }
        th, td { border: 1px solid #e5e7eb; padding: 8px; text-align: left; }
        th { background: #111827; color: #fff; }
        .watermark { position: fixed; top: 30%; left: 20%; width: 60%; opacity: 0.08; z-index: -1; }
    </style>
</head>
<body>
    <?php if($logo): ?>
        <img class="watermark" src="<?php echo e($logo); ?>" alt="Watermark">
    <?php endif; ?>
    <div class="header">
        <?php if($logo): ?>
            <img class="logo" src="<?php echo e($logo); ?>" alt="Logo">
        <?php endif; ?>
        <div>
            <h1><?php echo e($title); ?></h1>
            <div class="subtitle"><?php echo e($subtitle); ?></div>
            <div class="subtitle">Tenant: <?php echo e($tenant); ?></div>
        </div>
    </div>

    <div class="meta">
        <?php $__currentLoopData = $meta; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="meta-row">
                <span class="meta-label"><?php echo e($label); ?></span>
                <span><?php echo e($value); ?></span>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php ($headerRow = is_array($headers[0] ?? null) ? $headers[0] : $headers); ?>
    <table>
        <thead>
            <tr>
                <?php $__currentLoopData = $headerRow; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e($header); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cell): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e($cell); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/exports/template.blade.php ENDPATH**/ ?>