<?php
    $active = 'audit';
    $tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::first();
    $audit = $tenant
        ? \App\Models\AuditLog::with('user')->where('tenant_id', $tenant->id)->where('id', $auditId)->first()
        : null;
?>

<?php $__env->startSection('title', 'Audit Log Details'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Audit Entry</p>
        <h1>Entry <?php echo e($audit?->id ?? $auditId ?? '-'); ?></h1>
        <p class="sub">Change log with actor and diff details.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/audit">Back to Audit Log</a>
        <a class="btn btn-primary" href="/exports/audit/<?php echo e($audit?->id ?? $auditId ?? 0); ?>/pdf">Export Entry</a>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Actor</div>
        <div class="list">
            <div class="list-item"><span>User</span><span class="chip"><?php echo e($audit?->user?->name ?? 'System'); ?></span></div>
            <div class="list-item"><span>Action</span><span class="chip"><?php echo e($audit?->action ?? '-'); ?></span></div>
            <div class="list-item"><span>Entity</span><span class="chip"><?php echo e($audit?->entity_type ? ucfirst(str_replace('_', ' ', $audit->entity_type)) : '-'); ?> <?php echo e($audit?->entity_id ? '#' . $audit->entity_id : ''); ?></span></div>
            <div class="list-item"><span>IP</span><span class="chip"><?php echo e($audit?->ip_address ?? '-'); ?></span></div>
            <div class="list-item"><span>Channel</span><span class="chip"><?php echo e(strtoupper($audit?->channel ?? 'web')); ?></span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Changes</div>
        <div class="list">
            <?php if(is_array($audit?->changes) && $audit->changes): ?>
                <?php $__currentLoopData = $audit->changes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $from = is_array($value) ? ($value['from'] ?? ($value[0] ?? '-')) : '-';
                        $to = is_array($value) ? ($value['to'] ?? ($value[1] ?? '-')) : $value;
                    ?>
                    <div class="list-item"><span><?php echo e($field); ?></span><span class="chip"><?php echo e($from); ?> -> <?php echo e($to); ?></span></div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="list-item"><span>No changes recorded</span><span class="chip">-</span></div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/audit-detail.blade.php ENDPATH**/ ?>