<div class="section-card">
    <div class="section">
        <strong>Artisan Utilization & Compliance</strong>
        <?php if(!empty($hr['metrics'])): ?>
            <table>
                <thead>
                    <tr>
                        <th>Artisan</th>
                        <th>Assigned</th>
                        <th>Completed</th>
                        <th>Avg Close (hrs)</th>
                        <th>Utilization</th>
                        <th>Compliance</th>
                        <th>Repeat Failures</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $hr['metrics']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($row['artisan_name'] ?? '-'); ?></td>
                            <td><?php echo e($row['assigned'] ?? 0); ?></td>
                            <td><?php echo e($row['completed'] ?? 0); ?></td>
                            <td><?php echo e($row['avg_close_hours'] ?? 'N/A'); ?></td>
                            <td><?php echo e(isset($row['utilization']) ? number_format($row['utilization'] * 100, 1) . '%' : 'N/A'); ?></td>
                            <td><?php echo e(isset($row['compliance_rate']) ? number_format($row['compliance_rate'] * 100, 1) . '%' : 'N/A'); ?></td>
                            <td><?php echo e($row['repeat_failures'] ?? 0); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="muted">No artisan metrics captured.</div>
        <?php endif; ?>
    </div>

    <div class="section">
        <strong>Findings</strong>
        <?php if(!empty($hr['findings'])): ?>
            <ul>
                <?php $__currentLoopData = $hr['findings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finding): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($finding['title'] ?? $finding); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php else: ?>
            <div class="muted">No HR findings captured.</div>
        <?php endif; ?>
    </div>

    <?php if(!empty($hr['data_confidence'])): ?>
        <div class="section">
            <strong>Data Confidence</strong>
            <ul>
                <?php $__currentLoopData = $hr['data_confidence']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($note); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/reports/partials/hr_section.blade.php ENDPATH**/ ?>