
<?php ($active = 'tenants'); ?>

<?php $__env->startSection('title', 'Tenants'); ?>

<?php ($tenants = \App\Models\Tenant::withCount(['assets', 'users'])->orderBy('name')->get()); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Tenants</p>
        <h1>Tenant Directory</h1>
        <p class="sub">Multi-tenant management and provisioning.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Invite Tenant</button>
        <button class="btn btn-primary">Create Tenant</button>
    </div>
</section>

<section class="card">
    <div class="table">
        <div class="table-row table-head">
            <div>Tenant</div><div>Plan</div><div>Assets</div><div>Users</div><div>Status</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $tenants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php ($status = strtolower($tenant->status ?? 'active')); ?>
            <?php ($badge = $status === 'active' ? 'badge-live' : ($status === 'trial' ? 'badge-warning' : 'badge')); ?>
            <a class="table-row" href="/ui/tenants/<?php echo e($tenant->id); ?>">
                <div><?php echo e($tenant->name); ?></div>
                <div><?php echo e($tenant->subscription_plan ?? 'Enterprise'); ?></div>
                <div><?php echo e($tenant->assets_count ?? 0); ?></div>
                <div><?php echo e($tenant->users_count ?? 0); ?></div>
                <div><span class="badge <?php echo e($badge); ?>"><?php echo e(ucfirst($status)); ?></span></div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No tenants found.</div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/tenants.blade.php ENDPATH**/ ?>