
<?php ($active = 'fuel'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($fuelLogs = $tenant ? \App\Models\FuelLog::with('asset')->where('tenant_id', $tenant->id)->latest('logged_at')->take(6)->get() : collect()); ?>

<?php $__env->startSection('title', 'Fuel Logs'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Fuel</p>
        <h1>Fuel Management</h1>
        <p class="sub">Track bowser vs station fueling with variance checks.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Variance Report</button>
        <button class="btn btn-primary">Log Fuel</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Fuel Variance</div>
        <div class="metric">-1.8%</div>
        <div class="metric-sub">Last 7 days</div>
    </div>
    <div class="card">
        <div class="card-title">Average Burn</div>
        <div class="metric">42 L/hr</div>
        <div class="metric-sub">Mobile plant</div>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Fuel Consumption Trend</div>
                <div class="card-sub">Liters per day</div>
            </div>
            <div class="chip">Last 14 days</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 88 L40 76 L80 84 L120 70 L160 78 L200 62 L240 72 L260 66 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,88 40,76 80,84 120,70 160,78 200,62 240,72 260,66"></polyline>
                <circle class="trend-dot" cx="120" cy="70" r="3"></circle>
                <circle class="trend-dot" cx="200" cy="62" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="66" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Avg 6,420 L/day</span>
            <span>Variance 1.8%</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Fuel by Source</div>
                <div class="card-sub">Bowser vs station</div>
            </div>
            <div class="chip">This month</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 72%"><span>Bowser</span></div>
                <div class="chart-bar" style="--value: 38%"><span>Station</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Fuel Logs</div>
            <div class="card-sub">Bowser and station entries</div>
        </div>
        <div class="chip">Updated 1h ago</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Asset</div><div>Source</div><div>Qty</div><div>Cost</div><div>Variance</div><div>Logged</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $fuelLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <a class="table-row" href="/ui/fuel/<?php echo e($log->id); ?>">
                <div><?php echo e($log->asset?->name ?? 'Asset'); ?></div>
                <div><?php echo e(ucfirst($log->source ?? 'source')); ?></div>
                <div><?php echo e($log->quantity ? number_format($log->quantity, 0) . ' L' : '-'); ?></div>
                <div><?php echo e($log->total_cost ? '$' . number_format($log->total_cost, 0) : '-'); ?></div>
                <div><?php echo e($log->variance ? number_format($log->variance, 1) . '%' : '-'); ?></div>
                <div><?php echo e($log->logged_at?->format('H:i') ?? '-'); ?></div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No fuel logs found.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/fuel.blade.php ENDPATH**/ ?>