
<?php ($active = 'pm-schedules'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($schedules = $tenant ? \App\Models\PmSchedule::with('asset')->where('tenant_id', $tenant->id)->orderBy('next_meter_reading')->take(6)->get() : collect()); ?>

<?php $__env->startSection('title', 'PM Schedules'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Preventive Maintenance</p>
        <h1>PM Schedules</h1>
        <p class="sub">Schedule work by hours, km, cycles, or calendar.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Templates</button>
        <button class="btn btn-primary">Create Schedule</button>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Compliance Trend</div>
                <div class="card-sub">On-time PM completion</div>
            </div>
            <div class="chip">Last 12 weeks</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 88 L40 82 L80 78 L120 72 L160 66 L200 62 L240 56 L260 50 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,88 40,82 80,78 120,72 160,66 200,62 240,56 260,50"></polyline>
                <circle class="trend-dot" cx="80" cy="78" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="66" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="50" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>On-time 88-95%</span>
            <span>Overdue 8</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Schedule Mix</div>
                <div class="card-sub">By interval type</div>
            </div>
            <div class="chip">Active</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 76%"><span>Hours</span></div>
                <div class="chart-bar" style="--value: 52%"><span>Calendar</span></div>
                <div class="chart-bar" style="--value: 34%"><span>KM</span></div>
                <div class="chart-bar" style="--value: 20%"><span>Cycles</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Upcoming Services</div>
            <div class="card-sub">Next 30 days</div>
        </div>
        <div class="chip">Auto-updated</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Asset</div><div>Schedule</div><div>Type</div><div>Next Due</div><div>Meter</div><div>Status</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <a class="table-row" href="/ui/pm-schedules/<?php echo e($schedule->id); ?>">
                <div><?php echo e($schedule->asset?->name ?? 'Asset'); ?></div>
                <div><?php echo e($schedule->name); ?></div>
                <div><?php echo e(ucfirst($schedule->interval_unit ?? $schedule->schedule_type)); ?></div>
                <div><?php echo e($schedule->next_due_at?->format('M d') ?? '-'); ?></div>
                <div><?php echo e($schedule->next_meter_reading ? number_format($schedule->next_meter_reading, 0) : '-'); ?></div>
                <div><span class="badge <?php echo e($schedule->active ? 'badge-live' : 'badge-warning'); ?>"><?php echo e($schedule->active ? 'On Track' : 'Due Soon'); ?></span></div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No PM schedules found.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/pm-schedules.blade.php ENDPATH**/ ?>