<div class="section-card">
    <div class="section">
        <strong>Finance Metrics</strong>
        <table>
            <thead>
                <tr>
                    <th>PR Aging (days)</th>
                    <th>PO Aging (days)</th>
                    <th>Invoice Aging (days)</th>
                    <th>Unpaid Total</th>
                    <th>Spend vs Budget</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($finance['metrics']['pr_aging_days'] ?? 'N/A'); ?></td>
                    <td><?php echo e($finance['metrics']['po_aging_days'] ?? 'N/A'); ?></td>
                    <td><?php echo e($finance['metrics']['invoice_aging_days'] ?? 'N/A'); ?></td>
                    <td><?php echo e(isset($finance['metrics']['unpaid_total']) ? '$' . number_format($finance['metrics']['unpaid_total'], 2) : 'N/A'); ?></td>
                    <td><?php echo e(isset($finance['metrics']['spend_vs_budget']) ? number_format($finance['metrics']['spend_vs_budget'], 1) . '%' : 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <strong>Invoice Aging Buckets</strong>
        <table>
            <thead>
                <tr>
                    <th>0-30</th>
                    <th>31-60</th>
                    <th>61-90</th>
                    <th>90+</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e(isset($finance['aging_buckets']['0-30']) ? '$' . number_format($finance['aging_buckets']['0-30'], 2) : 'N/A'); ?></td>
                    <td><?php echo e(isset($finance['aging_buckets']['31-60']) ? '$' . number_format($finance['aging_buckets']['31-60'], 2) : 'N/A'); ?></td>
                    <td><?php echo e(isset($finance['aging_buckets']['61-90']) ? '$' . number_format($finance['aging_buckets']['61-90'], 2) : 'N/A'); ?></td>
                    <td><?php echo e(isset($finance['aging_buckets']['90+']) ? '$' . number_format($finance['aging_buckets']['90+'], 2) : 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <strong>Top Unpaid Exposure by Vendor</strong>
        <?php if(!empty($finance['top_vendors'])): ?>
            <table>
                <thead>
                    <tr>
                        <th>Vendor</th>
                        <th>Unpaid Exposure</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $finance['top_vendors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor => $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($vendor); ?></td>
                            <td>$<?php echo e(number_format($amount, 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="muted">No unpaid exposure data available.</div>
        <?php endif; ?>
    </div>

    <div class="section">
        <strong>Flagged Items</strong>
        <?php if(!empty($finance['findings'])): ?>
            <ul>
                <?php $__currentLoopData = $finance['findings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finding): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($finding['title'] ?? $finding); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php else: ?>
            <div class="muted">No finance findings captured.</div>
        <?php endif; ?>
    </div>

    <?php if(!empty($finance['data_confidence'])): ?>
        <div class="section">
            <strong>Data Confidence</strong>
            <ul>
                <?php $__currentLoopData = $finance['data_confidence']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($note); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/reports/partials/finance_section.blade.php ENDPATH**/ ?>