<?php

require __DIR__ . '/../../vendor/autoload.php';
$app = require __DIR__ . '/../../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Domain\AI\ToolExecutor;
use App\Models\User;

$user = User::find(1);
if (!$user) {
    echo "Reporter not found\n";
    exit(1);
}

$executor = app(ToolExecutor::class);
$actions = [
    [
        'asset' => '27',
        'priority' => 'critical',
        'title' => 'Jaw Crusher Motor vibration - structural looseness and unbalance (P1)',
        'plan' => [
            'Inspect and torque motor hold-down bolts and base.',
            'Repair or strengthen motor support structure.',
            'Clean motor cooling fan and crusher pulleys to remove dust buildup.',
            'Check balance after cleaning; schedule balancing if vibration persists.',
        ],
        'finding' => 'Overall vibration trending 3.0 to 9.8 mm/s RMS; dominant 1x vibration indicates structural looseness and unbalance.',
    ],
    [
        'asset' => '4',
        'priority' => 'high',
        'title' => 'Cone Crusher A bearing fault (P2)',
        'plan' => [
            'Lubricate crusher bearings and verify lubrication condition.',
            'Inspect bearing condition; plan replacement if defect is confirmed.',
            'Continue monitoring or trending after lubrication.',
        ],
        'finding' => 'Impacts up to 5.7 Gs; suspected bearing defect at about 225Hz.',
    ],
    [
        'asset' => '44',
        'priority' => 'high',
        'title' => 'Cone Crusher B motor structural looseness (P2)',
        'plan' => [
            'Inspect and tighten motor hold-down bolts.',
            'Repair or strengthen motor support structure.',
            'Isolate motor base-frame from crusher structure to reduce transmitted vibration.',
        ],
        'finding' => '1x vibration indicates structural looseness at motor DE.',
    ],
    [
        'asset' => '5',
        'priority' => 'critical',
        'title' => 'Cone Crusher B crusher bearing and lubrication fault (P1)',
        'plan' => [
            'Lubricate bearings immediately and check lubrication system for faults.',
            'Inspect bearings for damage; plan replacement if required.',
            'Verify vibration trend after lubrication.',
        ],
        'finding' => 'Vibration trending 9.2 to 16.4 mm/s RMS; impacts up to 14.8 Gs; broadband noise indicates lubrication fault.',
    ],
    [
        'asset' => '31',
        'priority' => 'critical',
        'title' => 'Vibro Screen 1 motor looseness and belt misalignment (P1)',
        'plan' => [
            'Repair or reinforce cracked motor support frame.',
            'Inspect and torque motor hold-down bolts.',
            'Inspect or replace worn belts as required.',
            'Align belts and set correct tension.',
        ],
        'finding' => 'Vibration 50.9 mm/s RMS and axial 13.3 to 21.8 mm/s; strong 1x indicates looseness and belt misalignment.',
    ],
    [
        'asset' => '38',
        'priority' => 'critical',
        'title' => 'Vibro Screen 2 motor looseness and loose belts (P1)',
        'plan' => [
            'Repair or reinforce cracked motor support frame.',
            'Inspect and torque motor hold-down bolts.',
            'Replace belts and ensure equal tensioning.',
            'Clean motor cooling fan and remove dust buildup.',
        ],
        'finding' => 'Vibration 57.8 mm/s RMS; strong 1x indicates looseness; belts flapping suggests unequal tension.',
    ],
    [
        'asset' => '40',
        'priority' => 'critical',
        'title' => 'Vibro Screen 3 motor structural looseness (P1)',
        'plan' => [
            'Inspect and torque motor hold-down bolts.',
            'Repair or strengthen motor support structure.',
            'Clean motor cooling fan and remove dust buildup.',
        ],
        'finding' => 'Vibration 7.6 mm/s RMS; strong 1x indicates structural looseness.',
    ],
];

$results = [];
foreach ($actions as $item) {
    $planLines = 'Action Plan:' . PHP_EOL . implode(PHP_EOL, array_map(fn ($line) => '- ' . $line, $item['plan']));
    $description = 'VA Report 21 Jan 2026 - Fourways Crushing Plant' . PHP_EOL
        . 'Findings: ' . $item['finding'] . PHP_EOL
        . $planLines;

    $args = [
        'asset' => $item['asset'],
        'title' => $item['title'],
        'description' => $description,
        'priority' => $item['priority'],
    ];

    $results[] = $executor->execute('workorders.create', $args, ['user' => $user, 'role_names' => []], 'web');
}

echo json_encode($results, JSON_PRETTY_PRINT) . PHP_EOL;
