<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class UiInteractionIntegrityTest extends TestCase
{
    use RefreshDatabase;

    public function test_ui_links_resolve_without_server_errors(): void
    {
        $pages = [
            '/ui',
            '/ui/assets',
            '/ui/work-orders',
            '/ui/purchase-requests/1',
            '/ui/reports',
            '/ui/settings',
        ];

        $hrefs = [];
        foreach ($pages as $page) {
            $response = $this->get($page);
            $this->assertLessThan(500, $response->getStatusCode(), "Page [$page] returned 5xx.");

            preg_match_all('/href="([^"]+)"/', $response->getContent(), $matches);
            foreach ($matches[1] as $href) {
                $href = trim($href);
                if ($href === '' || str_starts_with($href, '#') || str_contains($href, '{{')) {
                    continue;
                }
                if (!str_starts_with($href, '/')) {
                    continue;
                }
                if (str_starts_with($href, '/ui-assets/') || str_starts_with($href, '/build/')) {
                    continue;
                }
                $hrefs[$href] = true;
            }
        }

        foreach (array_keys($hrefs) as $href) {
            $status = $this->get($href)->getStatusCode();
            $this->assertLessThan(500, $status, "Link [$href] returned 5xx.");
        }
    }

    public function test_ui_buttons_have_a_functional_hook(): void
    {
        $pages = [
            '/ui',
            '/ui/work-orders',
            '/ui/purchase-requests/1',
            '/ui/settings',
        ];

        foreach ($pages as $page) {
            $response = $this->get($page);
            $this->assertLessThan(500, $response->getStatusCode(), "Page [$page] returned 5xx.");

            preg_match_all('/<button\b([^>]*)>/i', $response->getContent(), $buttons);
            foreach ($buttons[1] as $rawAttributes) {
                $attrs = strtolower($rawAttributes);
                $hasHook = str_contains($attrs, 'data-')
                    || str_contains($attrs, 'class="btn')
                    || str_contains($attrs, "class='btn")
                    || str_contains($attrs, 'type="submit"')
                    || str_contains($attrs, "type='submit'");

                $this->assertTrue(
                    $hasHook,
                    "Button without clear action hook on page [$page]: <$rawAttributes>"
                );
            }
        }
    }
}

