<?php

namespace Tests\Feature;

use App\Models\AgentNotification;
use App\Models\Tenant;
use App\Models\WeeklyReport;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Artisan;
use Tests\TestCase;

class WeeklyAiAgentsReportTest extends TestCase
{
    use RefreshDatabase;

    public function test_weekly_report_command_creates_pdf(): void
    {
        config(['weekly_reports.telegram_send_enabled' => false]);

        $tenant = Tenant::factory()->create();

        AgentNotification::create([
            'tenant_id' => $tenant->id,
            'agent_key' => 'kpi_analyst',
            'agent_name' => 'KPI Analyst Agent',
            'severity' => 'info',
            'title' => 'Weekly KPI Report',
            'summary' => 'Weekly KPI Report: Availability 92%.',
            'payload' => [
                'availability' => 92.0,
                'utilization' => 71.5,
                'mtbf' => 40.2,
                'fuel_efficiency' => 18.4,
            ],
            'recipients' => ['management'],
            'status' => 'sent',
            'sent_at' => now(),
        ]);

        Artisan::call('reports:weekly-ai-agents', [
            '--tenant' => $tenant->id,
            '--force' => true,
        ]);

        $report = WeeklyReport::where('tenant_id', $tenant->id)->first();
        $this->assertNotNull($report);
        $this->assertNotNull($report->pdf_path);
        $this->assertFileExists(storage_path('app/' . $report->pdf_path));
    }
}
