<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Models\Tenant;
use Illuminate\Foundation\Testing\RefreshDatabase;

class TenantTest extends TestCase
{
    use RefreshDatabase;

    public function test_tenant_creation()
    {
        $tenant = Tenant::create([
            'name' => 'Test Tenant',
            'email' => 'tenant@example.com',
            'password' => 'securepassword',
            'subdomain' => 'test-tenant',
        ]);

        $this->assertDatabaseHas('tenants', [
            'email' => 'tenant@example.com',
        ]);
    }

    public function test_tenant_update()
    {
        $tenant = Tenant::factory()->create();

        $tenant->update(['name' => 'Updated Tenant']);

        $this->assertEquals('Updated Tenant', $tenant->fresh()->name);
    }

    public function test_tenant_deletion()
    {
        $tenant = Tenant::factory()->create();

        $tenant->delete();

        $this->assertModelMissing($tenant);
    }
}
